#include <iostream>
#include <vector>
#include <string>
using namespace std;
struct krv {
    int z, a, b, ab;
};

enum class krvniTip {
    Nulta, A, B, AB
};

struct pacijent : krv {
    krvniTip tip;
    int potreba;

    pacijent() = default;

    pacijent(krvniTip tip, int potreba)
        : krv{}
        , tip{ tip }
        , potreba{ potreba } {}
};

pacijent ucitajPacijenta() {
    string tip;
    cin >> tip;

    int potreba;
    cin >> potreba;

    if (tip == "O") {
        return { krvniTip::Nulta, potreba };
    }
    else if (tip == "A") {
        return { krvniTip::A, potreba };
    }
    else if (tip == "B") {
        return { krvniTip::B, potreba };
    }
    else if (tip == "AB") {
        return { krvniTip::AB, potreba };
    }
    else {
        return {};
    }
}

void transfuzija(int& braunila, int& baraKrvi, int& potreba) {
    if (baraKrvi >= potreba) {
        braunila += potreba;
        baraKrvi -= potreba;
        potreba = 0;
    }
    else {
        braunila += baraKrvi;
        potreba -= baraKrvi;
        baraKrvi = 0;
    }
}

bool donate(vector<pacijent>& pacijenti, krv& stock, krvniTip tip) {
    for (pacijent& p : pacijenti) {
        if (p.tip == tip) {
            switch (tip) {
            case krvniTip::Nulta: {
                transfuzija(p.z, stock.z, p.potreba);
                if (p.potreba != 0) {
                    return false;
                }
                break;
            }

            case krvniTip::A: {
                transfuzija(p.a, stock.a, p.potreba);
                transfuzija(p.z, stock.z, p.potreba);
                if (p.potreba != 0) {
                    return false;
                }
                break;
            }

            case krvniTip::B: {
                transfuzija(p.b, stock.b, p.potreba);
                transfuzija(p.z, stock.z, p.potreba);
                if (p.potreba != 0) {
                    return false;
                }
                break;
            }

            case krvniTip::AB: {
                transfuzija(p.z, stock.z, p.potreba);
                transfuzija(p.ab, stock.ab, p.potreba);
                transfuzija(p.a, stock.a, p.potreba);
                transfuzija(p.b, stock.b, p.potreba);
                if (p.potreba != 0) {
                    return false;
                }
                break;
            }
            }
        }
    }
    return true;
}

int main() {
    krv stock;
    vector<pacijent> pacijenti;

    int n;
    cin >> n;
    cin >> stock.z >> stock.a >> stock.b >> stock.ab;
    for (int i = 0; i < n; ++i) {
        pacijenti.push_back(ucitajPacijenta());
    }

    for (krvniTip tip : {krvniTip::Nulta, krvniTip::A, krvniTip::B, krvniTip::AB}) {
        if (!donate(pacijenti, stock, tip)) {
            cout << "nemoguce";
            return 1;
        }
    }
    cout << "moguce" << endl;
    for (pacijent p : pacijenti) {
        cout << p.z << ' ' << p.a << ' ' << p.b << ' ' << p.ab <<endl;
    }
}